using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication
{
    public class Class : Gemini.Core.WebApplication.Base.WebPageComponent
    {
        private PI.WA.N300.WebPageManager.BL.Manager _blWebPageManager = null;
        private PI.WA.N300.WebPageManager.BL.Engine _webPageEngine = null;

        public Class(PI.WA.N300.WebPageManager.BL.Engine WebPageEngine, string Name, string ComponentName, Gemini.Core.WebApplication.Interface.IEnvironment Environment, int? SlotID, Gemini.Core.BL.Interface.IParamConfig TemplateParam, string ProfileName)
            : base(WebPageEngine.BID, Name, ComponentName, Environment, SlotID, TemplateParam, ProfileName)
        {
            _webPageEngine = WebPageEngine;
            _blWebPageManager = new PI.WA.N300.WebPageManager.BL.Manager(Environment, ProfileName);
        }

        private BL.ELearning _blELearning = null;
        public BL.ELearning BLELearning
        {
            get
            {
                if (_blELearning == null)
                {
                    _blELearning = new PI.ZB.N1200.ELearning.BL.ELearning(Environment, null);
                }
                return _blELearning;
            }
        }

        public override long ClientID
        {
            get { return BLELearning.ClientID; }
        }

        public override bool Save()
        {
            return true;
        }

        public override void Load()
        {
            // instructor musi by zawsze
            int? _instructorID = Environment.GetRequestParamInt("InstructorID", 0);
            if (_instructorID == 0)
            {
                return;
            }

            BL.BO.Instructor _instructor = BLELearning.InstructorRestore(_instructorID);
            if (_instructor == null)
            {
                return;
            }

            // 0 - nic, nie przetwarzamy
            // 1 - list for instructor
            // 2 - details for instructor
            int? _classMode = Environment.GetRequestParamInt("ClassMode", 0);
            if ((_classMode == null) || (_classMode == 0))
            {
                return;
            }

            XML.Element.Add("ClassMode", _classMode);
            switch (_classMode.Value)
            {
                case 1:
                    // lista klas
                    XML.Element.Start("ClassList");
                    List<BL.BO.Class> _listClass = BLELearning.ClassRestore(_instructor);
                    foreach (BL.BO.Class _loopClass in _listClass)
                    {
                        XML.Element.Start("Class");
                        XML.Element.Attribute("ID", _loopClass.ID);
                        XML.Element.Attribute("InstructorID", _loopClass.InstructorID);
                        XML.Element.Attribute("Name", _loopClass.Name);
                        XML.Element.Attribute("SchoolID", _loopClass.SchoolID);
                        XML.Element.End();
                    }
                    XML.Element.End();
                    break;
                case 2:
                    int? _classID = Environment.GetRequestParamInt("ClassID", 0);
                    if (_classID > 0)
                    {
                        BL.BO.Class _class = BLELearning.ClassRestore(_classID);
                        if (_class != null)
                        {
                            XML.Element.Start("Class");
                            XML.Element.Attribute("ID", _class.ID);
                            XML.Element.Attribute("InstructorID", _class.InstructorID);
                            XML.Element.Attribute("Name", _class.Name);
                            XML.Element.Attribute("SchoolID", _class.SchoolID);
                            XML.Element.End();
                        }
                    }
                    break;
            }
        }

        public override bool IsValid
        {
            get { return true; }
        }

        public override DateTime EditDate
        {
            get { return DateTime.Now; }
        }

        public override bool IsParamKey(long ParamKey)
        {
            return false;
        }

        public override object GetParamKey(long ParamKey, params object[] Params)
        {
            return null;
        }

        public override XmlDocument XHTML()
        {
            return XHTML(_webPageEngine.ComponentDescriptions[Name].XSL, _webPageEngine.ComponentDescriptions[Name].XML);
        }
    }
}
